# 🔒 Cyber Security Risk Assessment Report

---

## 📋 Assessment Metadata

| Field | Value |
|-------|-------|
| **Title** | [Concise risk description, e.g., "Log4Shell RCE in Customer Portal"] |
| **Date** | [Assessment completion date] |
| **Prepared By** | Cyber Security Risk Assessment Agent |
| **Requested By** | [Requester name/team] |
| **Assessment ID** | [Optional: Unique identifier] |

---

## 📊 Executive Summary

> [2-3 sentence high-level summary of the risk and its rating. This should be readable by non-technical executives.]

### Risk Rating

| **Risk Rating** | **Risk Score** | **Impact** | **Likelihood** |
|:---------------:|:--------------:|:----------:|:--------------:|
| **[Low / Medium / High / Very High]** | **[1-16]** | **[1-4]** | **[1-4]** |

**Recommended Priority:** 🔴 Critical / 🟠 High / 🟡 Medium / 🟢 Low

---

## 📖 Scenario Background

[75-150 words describing the risk scenario. Include:
- What vulnerability or threat was identified
- What systems or assets are affected  
- Why this assessment was requested
- Key context about the organization or environment
- When the risk was discovered or reported

Write in clear, accessible language avoiding unnecessary jargon. Assume reader has business context but limited technical background.]

---

## 🔍 Key Assumptions

> Important assumptions made during this assessment

[List all significant assumptions made during the assessment. For each assumption, use a separate subsection:]

### Assumption 1: [Assumption Topic]

- **Assumption:** [What was assumed]
- **Rationale:** [Why necessary]
- **Confidence:** 🟢 High / 🟡 Medium / 🔴 Low
- **Impact on Assessment:** [How affects risk rating]

### Assumption 2: [Assumption Topic]

- **Assumption:** [What was assumed]
- **Rationale:** [Why necessary]
- **Confidence:** 🟢 High / 🟡 Medium / 🔴 Low
- **Impact on Assessment:** [How affects risk rating]

[If no material assumptions were needed, state: "✅ No significant assumptions were required. Assessment based on verified information from [sources]."]

---

## ⚠️ Information Gaps

> Areas where additional information could improve assessment confidence

[List any material information that was unavailable during assessment:]

- ❌ **[Gap 1]:** [Description and how it limits assessment confidence]
- ❌ **[Gap 2]:** [Description and how it limits assessment confidence]

[If no gaps, state: "✅ All material information required for assessment was available."]

---

## 🎯 Risk Definition

### 🚨 Risk Statement

> [One sentence following format: "There is a risk that [threat actor] could [exploit vulnerability/attack vector] to [achieve impact] affecting [asset/business process]"]

### 📅 Risk Event

[2-4 sentences describing the specific incident scenario if the risk materializes. Include:
- How the attack begins (initial access)
- How it progresses (key steps)
- What the attacker achieves (objective)
- What systems/data are compromised]

---

## 💎 Assets in Scope

> Critical systems, data, and business processes at risk

| Asset | Description | Classification | Criticality |
|-------|-------------|----------------|-------------|
| **[Asset 1 Name]** | [Brief description] | [Data classification] | 🔴 Critical / 🟠 High / 🟡 Medium / 🟢 Low |
| **[Asset 2 Name]** | [Brief description] | [Data classification] | 🔴 Critical / 🟠 High / 🟡 Medium / 🟢 Low |

### 📝 Asset Details

**[Asset 1 Name]:** [Detailed description including business criticality, revenue impact, data processed, compliance scope]

**[Asset 2 Name]:** [Detailed description including business criticality, revenue impact, data processed, compliance scope]

---

## 👥 Threat Actors

> Potential adversaries and their motivations

| **Threat Actor** | **Capability** | **Motivation** | **Targeting Likelihood** |
|------------------|----------------|----------------|--------------------------|
| **[Threat Actor Type 1]** | [Low/Medium/High/Advanced] | [Financial/Espionage/Disruption/Ideology] | 🔴 High / 🟡 Medium / 🟢 Low |
| **[Threat Actor Type 2]** | [Low/Medium/High/Advanced] | [Financial/Espionage/Disruption/Ideology] | 🔴 High / 🟡 Medium / 🟢 Low |

---

## 🗺️ Attack Paths

> Detailed scenarios showing how adversaries could exploit this risk

### 🎯 Attack Path 1: [Descriptive Name]

**Overview:**
[50-100 word description of the attack sequence]

**Attack Chain:**

1. **🔓 Initial Access:** [How attacker gains initial foothold - specific technique + MITRE ATT&CK ID]
2. **⚡ Execution:** [How exploit is triggered or malicious code runs + MITRE ATT&CK ID]
3. **[Additional Step]:** [Description + MITRE ATT&CK ID if applicable]
4. **[Additional Step]:** [Description + MITRE ATT&CK ID if applicable]
5. **🎯 Objective Achievement:** [How attacker accomplishes their goal + MITRE ATT&CK ID]

---

### 🎯 Attack Path 2: [Descriptive Name]

[Repeat structure for each attack path]

---

## ✅ Existing Compensating Controls

> Security measures currently in place

| **Control** | **Protection Provided** | **Limitations** |
|-------------|------------------------|-----------------|
| 🛡️ **[Control 1 Name]** | [What it does, effectiveness] | ⚠️ [Limitations and gaps] |
| 🛡️ **[Control 2 Name]** | [What it does, effectiveness] | ⚠️ [Limitations and gaps] |

[If no confirmed controls exist, state: "❌ No compensating controls have been verified as in place for this specific risk."]

---

## 🔴 Control Gaps / Weaknesses

> Missing or ineffective security controls that enable this risk

### ❌ Missing Controls
*Controls that should exist but don't*

| # | Missing Control | Why This Matters |
|---|-----------------|------------------|
| 1 | **[Missing Control 1]** | [How this gap enables the attack] |
| 2 | **[Missing Control 2]** | [How this gap enables the attack] |

### ⚠️ Weak or Ineffective Controls
*Controls that exist but have significant limitations*

| # | Weak Control | Weakness / How It's Bypassed |
|---|--------------|------------------------------|
| 1 | **[Weak Control 1]** | [What the weakness is and how it enables attack] |
| 2 | **[Weak Control 2]** | [What the weakness is and how it enables attack] |

---

## 💥 Impact Assessment

### Impact Level: **[1 / 2 / 3 / 4]** - <span style="font-size: 20px;">[Low 🟢 / Medium 🟡 / High 🟠 / Very High 🔴]</span>

### 📊 Impact Breakdown

| Impact Category | Assessment |
|-----------------|------------|
| **💼 Business Impact** | [Operational disruption details] |
| **💰 Financial Impact** | [Direct costs, revenue loss, fines] |
| **⚖️ Regulatory Impact** | [Compliance violations, reporting obligations] |
| **📰 Reputational Impact** | [Customer trust, competitive position] |

### 📝 Justification

[3-5 sentences explaining why this impact level was selected. Must include:
- Primary consequences driving the impact level (business, financial, regulatory)
- Quantified or estimated magnitude where possible ($ amounts, # of customers, downtime duration)
- Specific regulatory requirements or compliance obligations triggered
- Reference to impact criteria from scoring document
- Why this level vs. the level above/below]

---

## 📈 Likelihood Assessment

### Likelihood Level: **[1 / 2 / 3 / 4]** - <span style="font-size: 20px;">[Low 🟢 / Medium 🟡 / High 🟠 / Very High 🔴]</span>

### 🔍 Likelihood Factors Analysis

| Factor | Assessment |
|--------|------------|
| **🔨 Exploit Maturity** | [Public exploit availability, CVSS score] |
| **🌐 Exposure Level** | [Internet-facing, network segmentation] |
| **👾 Threat Actor Interest** | [Active targeting, tool availability] |
| **🛡️ Control Effectiveness** | [Preventive and detective controls] |
| **📜 Historical Context** | [Past incidents, industry trends] |

### 📝 Justification

[3-5 sentences explaining why this likelihood level was selected. Must include:
- Exploit maturity and availability (CVE details, exploit code status)
- Exposure level (internet-facing, network segmentation, access controls)
- Threat actor capability and motivation (active targeting, tool availability)
- Control effectiveness (preventive and detective controls)
- Historical context or threat intelligence
- Probability estimate and how it maps to likelihood criteria]

---

## 🧮 Risk Calculation

### Calculation

| **Impact Level** | | **Likelihood Level** | | **Risk Score** |
|:----------------:|:---:|:-------------------:|:---:|:--------------:|
| **[1-4]** | ✖️ | **[1-4]** | = | **[1-16]** |
| [Low/Medium/High/Very High] | | [Low/Medium/High/Very High] | | |

### 🎯 Final Risk Rating

# [Low 🟢 / Medium 🟡 / High 🟠 / Very High 🔴]

**Risk Score:** **[1-16]** falls in the **[Low/Medium/High/Very High]** range

**Risk Rating Scale:**
- 1-2: Low Risk 🟢
- 3-4: Medium Risk 🟡
- 5-9: High Risk 🟠
- 10-16: Very High Risk 🔴

**Interpretation:** [Brief statement about what this means for prioritization and response urgency]

---

## ❓ Open Questions

> Unresolved questions that could affect the assessment

| **Question** | **Impact on Assessment** |
|--------------|--------------------------|
| ❓ **[Question 1]** | [How answer would change risk rating or confidence] |
| ❓ **[Question 2]** | [How answer would change risk rating or confidence] |

[If no open questions remain, state: "✅ All material questions have been resolved. Assessment is complete with high confidence in the risk rating."]

---

## 🎬 Recommended Next Actions

> Suggested immediate response steps

| **Priority** | **Action** |
|--------------|------------|
| 🔴 **Immediate** (0-24 hours) | **[Action 1]**<br/>[What should be done first] |
| 🟠 **Short-term** (24-72 hours) | **[Action 2]**<br/>[What should follow] |
| 🟡 **Long-term** (30+ days) | **[Action 3]**<br/>[Strategic improvements] |

*Note: This section is optional and should only be included if explicitly requested or if immediate actions are obvious from the risk assessment.*

---

**🔒 End of Risk Assessment Report 🔒**

---

*Generated by Cyber Security Risk Assessment Agent*  
*Report Version 2.0*

---

## 📚 Template Usage Notes

**For the Assessment Agent:**

### ✅ Quality Checklist Before Output

- [ ] All [bracketed placeholders] replaced with actual content
- [ ] Appropriate emojis used for risk ratings (🔴 Very High, 🟠 High, 🟡 Medium, 🟢 Low)
- [ ] Scenario Background is 75-150 words
- [ ] Each attack path is 50-100 words with numbered steps
- [ ] Impact justification is 3-5 sentences with specific evidence
- [ ] Likelihood justification is 3-5 sentences with specific evidence
- [ ] Risk score calculation is correct (Impact × Likelihood)
- [ ] Risk rating correctly maps score to Low/Medium/High/Very High
- [ ] Tables properly formatted with correct columns
- [ ] NO HTML tags used anywhere (no `<br/>`, `<details>`, `<summary>`, `<div>`, etc.)
- [ ] Use bullet points (-) or numbered lists instead of HTML for multi-line content
- [ ] No hallucinated data (CVEs, exploits, statistics)
- [ ] All assumptions clearly labeled with confidence indicators
- [ ] Template Usage Notes section deleted from final output

### 🎨 Visual Elements Guide

**Risk Rating Colors:**
- 🔴 Very High / Critical
- 🟠 High
- 🟡 Medium
- 🟢 Low

**Section Emojis:**
- 📋 Metadata
- 📊 Executive Summary
- 📖 Background
- 🔍 Assumptions
- ⚠️ Gaps
- 🎯 Risk Definition
- 💎 Assets
- 👥 Threat Actors
- 🗺️ Attack Paths
- ✅ Controls
- 🔴 Gaps
- 💥 Impact
- 📈 Likelihood
- 🧮 Calculation
- ❓ Questions
- 🎬 Actions

**Delete this entire "Template Usage Notes" section from final output.**

---
