# Risk Scoring Criteria
## Overview
This document defines the standardized criteria for assessing Impact and Likelihood in cybersecurity risk assessments. Use these definitions consistently to ensure comparability across assessments.

---
## Impact Levels
Impact measures the severity of consequences if the risk event occurs. Consider business, technical, and regulatory dimensions.

### Impact Level 1: Low
**Minor operational disruption; minimal financial or regulatory impact**

**Characteristics:**
- Temporary inconvenience to non-critical business function
- Resolved within hours with existing resources
- Limited to single non-critical system or small user subset
- No regulatory notification required
- No significant data loss or unauthorized access

**Business Impact Examples:**
- Internal administrative system unavailable for 2-4 hours
- Non-revenue-generating service temporarily degraded
- <10 internal users affected
- <$10K direct financial impact

**Data/Security Examples:**
- Access to non-sensitive internal data
- Temporary loss of non-critical system availability
- No PII, financial, or regulated data involved

**Regulatory Examples:**
- No regulatory reporting obligations triggered
- No compliance violations

---

### Impact Level 2: Medium
**Moderate operational disruption OR limited financial/regulatory consequences**

**Characteristics:**
- Notable disruption to business operations but not mission-critical
- Recovery requires dedicated effort but no external resources
- Affects multiple users or secondary business function
- Limited regulatory implications (reporting but minimal penalties)
- Contained data exposure without significant legal consequence

**Business Impact Examples:**
- Secondary customer-facing service degraded for 4-24 hours
- Manual workarounds required for business process
- 10-100 users or customers affected
- $10K-$100K direct financial impact (revenue loss, response costs)

**Data/Security Examples:**
- Unauthorized access to limited internal data (non-PII)
- Small-scale PII exposure (<1,000 records, minimal sensitivity)
- Partial system compromise without critical asset access

**Regulatory Examples:**
- Regulatory notification required (e.g., GDPR breach report) but low penalty risk
- Minor compliance violation with remediation path
- Limited legal/contractual exposure

<example>
SCENARIO: Web application defacement on marketing site
IMPACT: Level 2 (Medium)
REASONING: Reputational impact and temporary loss of marketing capability, but no data breach, no transaction processing disruption, and no regulatory violations. Recovery within 24 hours with internal team.
</example>

---

### Impact Level 3: High
**Major operational disruption; significant financial or regulatory consequences**

**Characteristics:**
- Severe disruption to critical business function or multiple functions
- Extended recovery time requiring external assistance
- Substantial customer/stakeholder impact
- Significant regulatory penalties or legal exposure
- Material data breach or intellectual property loss

**Business Impact Examples:**
- Primary revenue-generating system unavailable 24-72 hours
- Critical business process completely disrupted
- 100-10,000 customers affected
- $100K-$1M direct financial impact
- Significant reputational damage requiring PR response

**Data/Security Examples:**
- Unauthorized access to substantial PII (1,000-50,000 records)
- Exposure of financial records, health data, or confidential IP
- Complete compromise of critical system with lateral movement potential
- Ransomware affecting multiple systems

**Regulatory Examples:**
- GDPR/CCPA violations with substantial fine exposure ($100K-$1M range)
- SEC reporting obligations for material cybersecurity incident
- Industry regulator enforcement action (banking, healthcare)
- Class action lawsuit exposure

<example>
SCENARIO: Ransomware encrypts file servers containing customer contracts and operational data
IMPACT: Level 3 (High)
REASONING: Critical business operations halted for 48-96 hours pending restore from backups. Approximately 5,000 customers experience service delays. Estimated $400K impact (lost revenue + response costs + legal). No PII exposed but significant operational disruption. Regulatory reporting required but manageable penalties.
</example>

---

### Impact Level 4: Very High
**Critical business interruption; severe financial, regulatory, or reputational impact**

**Characteristics:**
- Existential threat to business operations or viability
- Recovery measured in weeks, potentially requiring business transformation
- Massive stakeholder impact (customers, partners, employees, public)
- Severe regulatory penalties potentially exceeding $1M
- Major data breach with long-term consequences

**Business Impact Examples:**
- Core business systems unavailable >72 hours
- Multiple critical business functions simultaneously disrupted
- >10,000 customers affected or all operations ceased
- >$1M direct financial impact
- Existential reputational damage (loss of customer trust, competitive position)

**Data/Security Examples:**
- Massive PII breach (>50,000 records or highly sensitive data)
- Complete compromise of production environment
- Critical infrastructure disruption (OT/ICS environments)
- Supply chain attack affecting multiple organizations
- Destruction of critical data without recovery option

**Regulatory Examples:**
- GDPR maximum penalty tier (up to 4% global revenue)
- HIPAA violations with criminal prosecution potential
- SOX compliance failure for public company
- Loss of critical certifications/licenses (PCI-DSS, FedRAMP)
- Congressional inquiry or federal investigation

<example>
SCENARIO: Nation-state APT exfiltrates entire customer database (250,000 records with PII/financial data) and maintains persistent access for 6 months
IMPACT: Level 4 (Very High)
REASONING: Massive GDPR breach notification affecting 250K EU citizens, estimated €2-5M penalty exposure. Class action lawsuit filed. Customer churn estimated at 30% over 12 months ($3M revenue impact). Multi-week forensic investigation and remediation ($500K). Loss of industry certifications requiring re-audit. Competitive disadvantage from reputational damage. Total impact: $5-8M with long-term business viability concerns.
</example>

---

## Likelihood Levels

Likelihood estimates the probability of the risk event occurring within the next 12 months, given current controls and threat environment.

### Likelihood Level 1: Low
**<10% probability within 12 months**

**Characteristics:**
- Vulnerability difficult to exploit (requires specialized skills/access)
- Strong layered controls in place
- Limited threat actor interest or capability
- Low exposure (internal systems, restricted access)
- No known active exploitation

**Technical Indicators:**
- No public exploit code available
- CVSS Exploit Code Maturity: Unproven or Proof-of-Concept only
- Complex exploit chain required (multiple preconditions)
- Vulnerability requires authenticated access + additional privileges

**Environmental Indicators:**
- System not internet-facing (internal network only)
- Strong network segmentation isolating vulnerable system
- Multiple compensating controls (defense-in-depth)
- Active monitoring and detection capabilities
- Vulnerability not applicable to organization's technology stack

**Threat Context:**
- No threat actor demonstrated interest in this vulnerability
- Exploitation requires advanced persistent threat (APT) capabilities
- Low value target (no attractive data/access)

<example>
SCENARIO: Race condition vulnerability in internal HR application requiring local authenticated access
LIKELIHOOD: Level 1 (Low)
REASONING: No public exploits exist. Application only accessible via VPN to internal HR staff (20 users). Multi-factor authentication required. No known external interest. Would require insider threat with technical expertise - assessed <5% probability over 12 months.
</example>

---

### Likelihood Level 2: Medium
**10-49% probability within 12 months**

**Characteristics:**
- Vulnerability moderately difficult to exploit
- Partial controls in place but gaps exist
- Some threat actor interest but not widespread
- Moderate exposure with some limiting factors
- Limited active exploitation observed

**Technical Indicators:**
- Public proof-of-concept (POC) exploit exists
- CVSS Exploit Code Maturity: Functional
- Exploitation requires moderate skill level
- Some preconditions required (authenticated user, specific configuration)

**Environmental Indicators:**
- System has internet exposure but behind some controls (firewall, authentication)
- Some segmentation exists but not complete isolation
- Detective controls present but preventive controls limited
- Patching possible but delayed (30-90 day patch window)

**Threat Context:**
- Opportunistic scanning/exploitation possible
- Moderate threat actor interest (some targeting observed)
- Medium value target (some sensitive data/access)
- Historical exploitation rare but documented

<example>
SCENARIO: Outdated WordPress plugin with known XSS vulnerability on marketing blog
LIKELIHOOD: Level 2 (Medium)
REASONING: Public exploit available on Exploit-DB. Blog is internet-facing but contains no sensitive data and is segregated from internal network. WAF provides partial protection. Automated scanning likely (assessed 30% probability) but limited attacker motivation given low-value target. Patch available but deployment delayed 60 days due to compatibility testing.
</example>

---

### Likelihood Level 3: High
**50-90% probability within 12 months**

**Characteristics:**
- Vulnerability easily exploitable with available tools
- Weak or missing controls
- Active threat actor interest and targeting
- High exposure to potential attackers
- Active exploitation in the wild against similar targets

**Technical Indicators:**
- Public weaponized exploit available (Metasploit, GitHub)
- CVSS Exploit Code Maturity: High
- Exploitation requires minimal skill (script kiddie level)
- Few preconditions (works against default configurations)

**Environmental Indicators:**
- Internet-facing system with direct exposure
- Weak/no network segmentation
- Missing or ineffective preventive controls (no WAF, IPS disabled)
- Limited detective capabilities (no SIEM, incomplete logging)
- Patch available but not deployed (>90 day exposure window)

**Threat Context:**
- Active exploitation campaigns observed
- Automated exploit tools targeting this vulnerability
- High value target (customer data, financial systems, credentials)
- Multiple threat actor groups actively exploiting

<example>
SCENARIO: Unpatched SQL injection vulnerability in customer-facing e-commerce checkout process
LIKELIHOOD: Level 3 (High)
REASONING: Sqlmap and automated tools can exploit this vulnerability. Application is internet-facing with no WAF protection. OWASP Top 10 vulnerability actively targeted by both opportunistic attackers and organized crime groups. Database contains 50K customer payment records (high-value target). No effective preventive controls. Based on industry data, ~60% of internet-facing SQL injection vulnerabilities are exploited within 6 months of discovery.
</example>

---

### Likelihood Level 4: Very High
**>90% probability within 12 months**

**Characteristics:**
- Trivially exploitable vulnerability
- No effective controls
- Widespread active exploitation
- Maximum exposure to attackers
- Organizational/industry actively targeted

**Technical Indicators:**
- Fully weaponized exploit widely available and automated
- CVSS Exploit Code Maturity: High, incorporated into exploit frameworks
- Zero-click or requires no user interaction
- Works against all default configurations
- Active worm/botnet targeting this vulnerability

**Environmental Indicators:**
- Internet-facing with no protective controls whatsoever
- No network segmentation - direct access to critical assets
- No monitoring or detection capabilities
- Patch available but deployment blocked (technical debt, compatibility issues)
- OR zero-day vulnerability under active exploitation

**Threat Context:**
- Mass exploitation campaigns underway
- CISA KEV (Known Exploited Vulnerabilities) listing
- Ransomware groups actively targeting
- Nation-state APTs incorporating into campaigns
- Extremely high value target (critical infrastructure, regulated data, authentication systems)

<example>
SCENARIO: Log4Shell (CVE-2021-44228) in internet-facing Java application, discovered 72 hours after public disclosure
LIKELIHOOD: Level 4 (Very High)
REASONING: CVSS 10.0 critical vulnerability with trivial exploitation (single LDAP string). Metasploit module available, automated scanning rampant. CISA reports nation-state and ransomware groups actively exploiting. Application is internet-facing customer portal with no WAF. No patch deployed (compatibility testing required). Cloudflare data shows 45% of vulnerable systems exploited within 72 hours. Given application profile and exposure, >95% probability of exploitation attempt within 30 days.
</example>

---

## Likelihood Assessment Factors (Detailed)

Use these factors systematically when determining likelihood:

### Factor 1: Exploit Maturity
- **Theoretical** (CVSS: U): No exploit exists → Likelihood ≤ 2
- **POC exists** (CVSS: P): Proof-of-concept code published → Consider Likelihood 2
- **Functional** (CVSS: F): Working exploit available → Consider Likelihood 2-3
- **Weaponized** (CVSS: H): In exploit frameworks, automated → Consider Likelihood 3-4

### Factor 2: Exposure Level
- **Internal only** + Strong segmentation → Reduces likelihood by 1-2 levels
- **Internal** + Weak segmentation → Reduces likelihood by 1 level
- **Internet-facing** + Strong controls (WAF, IPS) → Neutral
- **Internet-facing** + Weak/No controls → Increases likelihood by 1-2 levels

### Factor 3: Threat Actor Capability & Motivation
- **Low capability required** + High value target → Increases likelihood
- **High capability required** + Low value target → Decreases likelihood
- **Active targeting observed** → Increases likelihood by 1-2 levels
- **No demonstrated interest** → Decreases likelihood by 1 level

### Factor 4: Control Effectiveness
- **Defense-in-depth** (multiple strong controls) → Decreases likelihood by 1-2 levels
- **Single control** (one strong control) → Decreases likelihood by 1 level
- **Weak controls** (bypassable, outdated) → Neutral or increases likelihood
- **No controls** → Increases likelihood by 1-2 levels

### Factor 5: Historical Context
- **Previously exploited** (this org) → Increases likelihood by 1-2 levels
- **Widely exploited** (industry) → Increases likelihood by 1 level
- **Rare exploitation** → Neutral
- **Never exploited** → Decreases likelihood by 1 level

---

## Risk Rating Matrix

Combine Impact and Likelihood scores to determine Risk Rating:

```
                     LIKELIHOOD
              1      2      3      4
            ┌──────┬──────┬──────┬──────┐
         1  │  1   │  2   │  3   │  4   │
            │ LOW  │ LOW  │ MED  │ MED  │
            ├──────┼──────┼──────┼──────┤
I     2     │  2   │  4   │  6   │  8   │
M           │ LOW  │ MED  │ HIGH │ HIGH │
P     ├──────┼──────┼──────┼──────┤
A     3     │  3   │  6   │  9   │  12  │
C           │ MED  │ HIGH │ HIGH │V.HIGH│
T     ├──────┼──────┼──────┼──────┤
      4     │  4   │  8   │  12  │  16  │
            │ MED  │ HIGH │V.HIGH│V.HIGH│
            └──────┴──────┴──────┴──────┘
```

**Risk Rating Thresholds:**
- **Risk Score 1-2**: Low Risk
- **Risk Score 3-4**: Medium Risk
- **Risk Score 5-9**: High Risk
- **Risk Score 10-16**: Very High Risk

---

## Decision Rules for Edge Cases

### When Uncertain Between Two Levels

**Default Rule**: Select the higher level (conservative approach)

**Exception**: Select lower level ONLY if you have strong evidence:
- Multiple independent controls verified as effective
- Historical data demonstrating lower actual probability
- Regulatory guidance specifically defining lower threshold
- Technical analysis proving lower impact scope

**Document your reasoning**: "Initially assessed as Level 3, but reduced to Level 2 based on [specific evidence]"

### When Multiple Factors Conflict

**Example**: High exposure + Strong controls

**Approach**:
1. Evaluate each factor independently
2. Identify the dominant factor (what has greatest influence)
3. Adjust for other factors (typically ±1 level)
4. Document the trade-off in justification

### When Probability is Borderline

**Example**: Estimated probability is 48-52% (border of Medium/High)

**Approach**:
1. Re-examine your evidence - is estimate actually precise?
2. Consider error bars - if range includes 50%, what's the conservative bound?
3. Select higher level (High/Level 3) per tie-break rule
4. Document: "Likelihood assessed at 50% ±10%, meeting threshold for Level 3"

---

## Calibration Examples

Use these examples to calibrate your assessments:

### Example 1: Outdated Software Library
- **Vulnerability**: jQuery 1.x with known XSS vulnerabilities
- **Context**: Used in internal employee portal, not internet-facing, no PII
- **Impact**: 2 (Medium) - affects employee productivity, no data breach
- **Likelihood**: 2 (Medium) - internal only, requires authenticated user to trigger XSS
- **Risk Score**: 4 (Medium Risk)

### Example 2: Unpatched Critical System
- **Vulnerability**: EternalBlue (SMB) on internet-facing legacy system
- **Context**: System handles customer orders, contains PII, no segmentation
- **Impact**: 4 (Very High) - customer data breach, operational disruption, regulatory fines
- **Likelihood**: 4 (Very High) - public exploits, active exploitation, no controls
- **Risk Score**: 16 (Very High Risk)

### Example 3: Misconfigured Cloud Storage
- **Vulnerability**: S3 bucket with public read access containing internal documents
- **Context**: Documents include org charts, policies, no PII/regulated data
- **Impact**: 2 (Medium) - reputational concern, no direct financial/regulatory impact
- **Likelihood**: 3 (High) - publicly discoverable, automated scanning tools exist
- **Risk Score**: 6 (High Risk)

### Example 4: Zero-Day in Isolated System
- **Vulnerability**: Theoretical RCE in SCADA system
- **Context**: Critical manufacturing system, air-gapped network, no known exploit
- **Impact**: 4 (Very High) - production halt, safety implications
- **Likelihood**: 1 (Low) - air-gapped, no exploit, requires physical access
- **Risk Score**: 4 (Medium Risk)

---
